<?php
    /**
    *
    * copyright (c) 2013-2022 Heliac Technologies
    * license http://opensource.org/licenses/gpl-license.php GNU GPL v3 
    *
    * linee guida per l'utilizzo del logo http://www.geecom.org/index.php?alias=linee-guida-per-luso-del-logo-geecom
    *
    */

    include "../../include/includeBaseControllerComponenti.php";
    include "../classi/Cruscotto.php";
    
    if(isset($_POST["operazione"])) {
        $operazione = filter_input(INPUT_POST,"operazione",FILTER_SANITIZE_STRING);
        $cruscotto  = new Cruscotto($geecomDb, filter_input(INPUT_POST, "id"));
    }
    else {
        $operazione = filter_input(INPUT_GET,"operazione",FILTER_SANITIZE_STRING);
        $cruscotto  = new Form($geecomDb, filter_input(INPUT_GET, "id"));
    }
    
    switch ($operazione) {
        case 'crea':
            $cruscotto->setNome(filter_input(INPUT_POST,"nome",FILTER_SANITIZE_ADD_SLASHES));
            $cruscotto->setSpazioOccupato(filter_input(INPUT_POST,"spazioOccupato",FILTER_SANITIZE_STRING));
            $cruscotto->crea();
            header("Location: ../creaCruscotto.php?id={$cruscotto->getId()}&status=200");
            break;
        case 'modifica':
            $cruscotto->setNome(filter_input(INPUT_POST,"nome",FILTER_SANITIZE_ADD_SLASHES));
            $cruscotto->setSpazioOccupato(filter_input(INPUT_POST,"spazioOccupato",FILTER_SANITIZE_STRING));
            $cruscotto->modifica();
            header("Location: ../creaCruscotto.php?id={$cruscotto->getId()}&status=250");
            break;
        case 'elimina':
            $cruscotto->elimina();
            echo "ok";
            break;
        case 'duplica':
            $cruscotto->caricaDatiDalDatabase();
            $idNuovaForm = $cruscotto->duplica();
            header("Location: ../creaCruscotto.php?id={$idNuovaForm}&status=260");
            break;
        case 'duplicaElemento':
            $idNuovoElemento = $cruscotto->duplicaElemento(filter_input(INPUT_GET, "idElemento",FILTER_SANITIZE_NUMBER_INT));
            header("Location: ../creaElemento.php?id={$idNuovoElemento}&status=210");
            break;
        case 'stampaElementi':
            $cruscotto->stampaElementi();
            break;
        case 'creaElemento':
            $nome   = filter_input(INPUT_POST, "nome",FILTER_SANITIZE_ADD_SLASHES);
            $tipo   = filter_input(INPUT_POST, "tipo",FILTER_SANITIZE_STRING);
            $cruscotto->creaElemento($nome,$tipo);
            echo "ok";
            break;
        case 'spostaElemento':
            $cruscotto->spostaElemento(filter_input(INPUT_POST, "idElemento",FILTER_SANITIZE_NUMBER_INT),filter_input(INPUT_POST, "posizione",FILTER_SANITIZE_NUMBER_INT));
            echo "ok";
            break;
        case 'modificaElemento':
            $idElemento  = filter_input(INPUT_POST,"idElemento",FILTER_SANITIZE_STRING);
            
            $spazioOccupato =filter_input(INPUT_POST,"spazioOccupato",FILTER_SANITIZE_STRING);
            $nome           = filter_input(INPUT_POST,"nome",FILTER_SANITIZE_ADD_SLASHES);
            $coloreSfondo   = filter_input(INPUT_POST,"coloreSfondo",FILTER_SANITIZE_STRING);
            $coloreTesti    = filter_input(INPUT_POST,"coloreTesti",FILTER_SANITIZE_STRING);
            $classiAggiuntive   = filter_input(INPUT_POST,"classiAggiuntive",FILTER_SANITIZE_STRING);
            $icona              = filter_input(INPUT_POST,"icona",FILTER_SANITIZE_STRING);
            $stile              = filter_input(INPUT_POST,"stile",FILTER_SANITIZE_STRING);
            $stilePulsanti      = filter_input(INPUT_POST,"stilePulsanti",FILTER_SANITIZE_STRING);
            $etichettaPulsante1 = filter_input(INPUT_POST,"etichettaPulsante1",FILTER_SANITIZE_STRING);
            $etichettaPulsante2 = filter_input(INPUT_POST,"etichettaPulsante2",FILTER_SANITIZE_STRING);
            $linkPulsante1      = filter_input(INPUT_POST,"linkPulsante1",FILTER_SANITIZE_STRING);
            $linkPulsante2      = filter_input(INPUT_POST,"linkPulsante2",FILTER_SANITIZE_STRING);
            $valoreMostrato     = filter_input(INPUT_POST,"valoreMostrato",FILTER_SANITIZE_STRING);
            $valoreDaMostrare   = filter_input(INPUT_POST,"valoreDaMostrare",FILTER_SANITIZE_STRING);
            $query              = filter_input(INPUT_POST,"query",FILTER_SANITIZE_ADD_SLASHES);
            
            $cruscotto->modificaElemento($idElemento, $spazioOccupato, $nome, $coloreSfondo, $coloreTesti,$classiAggiuntive,$icona,$stile,$stilePulsanti,$etichettaPulsante1,$etichettaPulsante2,$linkPulsante1,$linkPulsante2,$valoreMostrato,$valoreDaMostrare,$query);
            header("Location: ../creaElemento.php?id={$idElemento}&status=200");
            break;
        case 'eliminaElemento':
            $cruscotto->eliminaElemento(filter_input(INPUT_POST, "idElemento",FILTER_SANITIZE_NUMBER_INT));
            echo "ok";
            break;
    }
